//@author: catweasel
//@help: Moves particles away from each other
//@tags: particles, dx11
//@credits: 
bool reset;
StructuredBuffer<float3> resetPos;
struct particle
{
	float3 pos;
	float3 vel;
};
RWStructuredBuffer<particle> Output : BACKBUFFER;
int total;
float amount=1;
float maxradius;
//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(64, 1, 1)]
void CSConstantForce( uint3 DTid : SV_DispatchThreadID )
{
	if (reset)
	{
		Output[DTid.x].pos = resetPos[DTid.x];
		Output[DTid.x].vel = 0;		
	}
	
	else
	{

float3 posOrig =Output[DTid.x].pos;
float3 c=0;
		for( uint i = 0; i < total; i++ )
		{


			if (DTid.x != i)
//			{
	if (distance(Output[DTid.x].pos,Output[i].pos) < 0.01)//stop them merging but not very well :/
		{Output[DTid.x].pos += (Output[DTid.x].pos-Output[i].pos)*.01;}
			
				if (distance(Output[DTid.x].pos,Output[i].pos) < maxradius) //if I'm within range
				{
					c = (Output[DTid.x].pos-Output[i].pos)*amount;
//p				Output[DTid.x].vel += (posOrig-Output[DTid.x].pos);
				
//				}
				
			}
		}
		Output[DTid.x].pos+=c;
	}				
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 simulation
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSConstantForce() ) );
	}
}
